/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.DeviceClassProperties;
import com.ibm.hwmca.fw.mediasvc.DevicePropertiesFilenameFilter;
import com.ibm.hwmca.fw.mediasvc.HdDeviceProperties;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceProperties;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameterKeys;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameters;
import com.ibm.hwmca.fw.mediasvc.MediaServicesResourceBundle;
import com.ibm.hwmca.fw.mediasvc.NonHdDeviceProperties;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

class DiscoverDevices
implements MediaServicesErrorIds,
MediaServicesParameterKeys {
    private static final String TRACE_MASKT = "XMDADMDT";
    private static final String TRACE_MASKF = "XMDADMDF";
    private static final String TRACE_MASKD = "XMDADMDD";
    private static final String HD_PREFIX = "hd.";
    private static final String HD_PARTITION_PREFIX = "hd.partition.";
    private static final String NAME_SUFFIX = ".name";
    private static final String DESCRIPTION_SUFFIX = ".description";
    private static final String HDPROPERTIES = "media.hd.partition.info";
    private static final String DEVPROPERTIES = "media.device.properties";
    private static final String DEVICE_DETECT_SCRIPT = "media.device.detect.script";
    private static DiscoverDevices discoverDevices;
    private MediaServicesParameters mediaServicesParameters;
    private HashMap deviceClassPropertiesMap;
    private HashMap initialDeviceIdsMap;
    private HashMap currentDeviceIdsMap;

    private DiscoverDevices() {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.DiscoverDevices()");
        this.mediaServicesParameters = MediaServicesParameters.getMediaServicesParameters();
        this.deviceClassPropertiesMap = new HashMap();
        this.initialDeviceIdsMap = new HashMap();
        this.currentDeviceIdsMap = new HashMap();
        try {
            Iterator iterator;
            Set set;
            this.initialDeviceIdsMap.putAll(this.getHashMapOfDevices());
            Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): initialDeviceIdsMap.size() = " + this.initialDeviceIdsMap.size());
            HashMap usbDeviceIdsMap = this.getHashMapOfUSBDevices();
            if (usbDeviceIdsMap != null && !usbDeviceIdsMap.isEmpty()) {
                Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): usbDeviceIdsMap.size() = " + usbDeviceIdsMap.size());
                set = usbDeviceIdsMap.keySet();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    String deviceName = (String)iterator.next();
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): deviceName = " + deviceName);
                    if (this.currentDeviceIdsMap.containsKey(deviceName)) continue;
                    MediaDeviceIdentifier mediaDeviceIdentifier = (MediaDeviceIdentifier)usbDeviceIdsMap.get(deviceName);
                    if (mediaDeviceIdentifier != null) {
                        String deviceType = mediaDeviceIdentifier.getDeviceType();
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): deviceType = " + deviceType);
                        if (deviceType != null) {
                            if (!deviceType.equals("UM") && !deviceType.equals("DD")) continue;
                            DeviceClassProperties deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
                            if (deviceClassProperties != null) {
                                deviceClassProperties.incrementNumberOfDevices();
                                this.currentDeviceIdsMap.put(deviceName, mediaDeviceIdentifier);
                                Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): The device " + deviceName + " was added to the current map of devices.");
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): deviceClassProperties == null");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): deviceType == null");
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): mediaDeviceIdentifier == null");
                }
            } else if (usbDeviceIdsMap == null) {
                Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): usbDeviceIdsMap is null");
            } else {
                Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): usbDeviceIdsMap is empty");
            }
            Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): Setting dynamic device properties...");
            set = this.deviceClassPropertiesMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                String deviceType = (String)iterator.next();
                Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): deviceType = " + deviceType);
                DeviceClassProperties deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
                if (deviceClassProperties != null) {
                    if (deviceClassProperties.getNumberOfDevices() > 0) {
                        this.setDisplayableDescription(deviceClassProperties);
                        this.setPreferred(deviceClassProperties);
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): !(deviceClassProperties.getNumberOfDevices() > 0)");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "DiscoverDevices.DiscoverDevices(): deviceClassProperties == null");
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.DiscoverDevices()");
    }

    public static synchronized DiscoverDevices getDiscoverDevices() {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.getDiscoverDevices()");
        if (discoverDevices == null) {
            discoverDevices = new DiscoverDevices();
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.getDiscoverDevices()");
        return discoverDevices;
    }

    HashMap getHashMapOfDevices() throws MediaDeviceException {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.getHashMapOfDevices()");
        String devicePropertiesDirName = "";
        try {
            devicePropertiesDirName = BaseFileControl.getFilePath(this.mediaServicesParameters.getParm(DEVPROPERTIES)) + this.mediaServicesParameters.getParm(DEVPROPERTIES);
            Trace.trace(TRACE_MASKD, "DiscoverDevices.getHashMapOfDevices(): devicePropertiesDirName = " + devicePropertiesDirName);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        File devicePropertiesDir = new File(devicePropertiesDirName);
        DevicePropertiesFilenameFilter devicePropertiesFilenameFilter = new DevicePropertiesFilenameFilter();
        String[] devicePropertyFiles = devicePropertiesDir.list(devicePropertiesFilenameFilter);
        for (int i = 0; i < devicePropertyFiles.length; ++i) {
            DeviceClassProperties deviceClassProperties = null;
            try {
                deviceClassProperties = new DeviceClassProperties(devicePropertiesDirName + devicePropertyFiles[i]);
                this.deviceClassPropertiesMap.put(deviceClassProperties.getDeviceType(), deviceClassProperties);
                continue;
            }
            catch (Exception exc) {
                MediaDeviceException mdexc = new MediaDeviceException(exc);
                Trace.trace(TRACE_MASKF, mdexc);
                new FrameworkLog(MediaServicesErrorIds._logInfo, 610, mdexc).log();
                throw mdexc;
            }
        }
        this.instantiateNonHdDevices();
        this.instantiateHdDevices();
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.getHashMapOfDevices(): returns " + this.currentDeviceIdsMap.size() + " devices.");
        return this.currentDeviceIdsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void instantiateHdDevices() throws MediaDeviceException {
        block24: {
            Trace.trace(TRACE_MASKT, "-> DiscoverDevices.instantiateHdDevices()");
            FileInputStream fileInputStream = null;
            String hdFile = BaseFileControl.getFilePath("data") + this.mediaServicesParameters.getParm(DEVPROPERTIES) + this.mediaServicesParameters.getParm(HDPROPERTIES);
            Trace.trace(TRACE_MASKD, "DiscoverDevices.instantiateHdDevices(): hdFile = " + hdFile);
            fileInputStream = new FileInputStream(hdFile);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            for (int i = 0; i < properties.size() / 3; ++i) {
                block25: {
                    block26: {
                        IOException ioexc2222;
                        Object var14_17;
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Getting the device class properties for the new device.");
                        DeviceClassProperties deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get("HD");
                        if (deviceClassProperties == null) break block25;
                        String index = new Integer(i + 1).toString();
                        String mountPointKey = HD_PREFIX + index;
                        String mountPoint = properties.getProperty(mountPointKey);
                        if (mountPoint == null) break block26;
                        Trace.trace(TRACE_MASKT, "DiscoverDevices.instantiateHdDevices(): mountPoint = " + mountPoint);
                        FileReader fileReader = null;
                        BufferedReader bufferedReader = null;
                        boolean partitionFound = false;
                        try {
                            fileReader = new FileReader("/etc/fstab");
                            bufferedReader = new BufferedReader(fileReader);
                            String fstab_line = null;
                            while ((fstab_line = bufferedReader.readLine()) != null) {
                                Trace.trace(TRACE_MASKF, fstab_line);
                                if (fstab_line.indexOf(mountPoint) == -1) continue;
                                Trace.trace(TRACE_MASKT, "DiscoverDevices.instantiateHdDevices(): The fstab line contains the mount point " + mountPoint);
                                partitionFound = true;
                                break;
                            }
                            var14_17 = null;
                        }
                        catch (Throwable throwable) {
                            var14_17 = null;
                            try {
                                if (bufferedReader != null) {
                                    bufferedReader.close();
                                }
                            }
                            catch (IOException ioexc2222) {
                                Trace.trace(TRACE_MASKF, ioexc2222);
                            }
                            throw throwable;
                        }
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                        }
                        catch (IOException ioexc2222) {
                            Trace.trace(TRACE_MASKF, ioexc2222);
                        }
                        if (partitionFound) {
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The hard drive partition with mount point [" + mountPoint + "] was found in /etc/fstab");
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Incrementing the number of devices.");
                            deviceClassProperties.incrementNumberOfDevices();
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The number of devices = " + deviceClassProperties.getNumberOfDevices());
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Creating the new hard drive device properties.");
                            HdDeviceProperties hdDeviceProperties = new HdDeviceProperties(deviceClassProperties);
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Setting the mount point for the new device.");
                            hdDeviceProperties.setMountPoint(mountPoint);
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The mount point for the hard drive = " + hdDeviceProperties.getMountPoint());
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Setting the displayable name for the new device.");
                            String displayableNameKey = HD_PARTITION_PREFIX + index + NAME_SUFFIX;
                            hdDeviceProperties.setDisplayableName(new LocalizableText(properties.getProperty(displayableNameKey)));
                            Trace.trace(TRACE_MASKF, "The displayable name for the hard drive device = " + hdDeviceProperties.getDisplayableName());
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Setting the displayable description for the new device.");
                            String displayableDescriptionKey = HD_PARTITION_PREFIX + index + DESCRIPTION_SUFFIX;
                            hdDeviceProperties.setDisplayableDescription(new LocalizableText(properties.getProperty(displayableDescriptionKey)));
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The displayable description for the hard drive device = " + hdDeviceProperties.getDisplayableDescription());
                            if (properties.getProperty(mountPointKey).indexOf("upgrade") != -1) {
                                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Found the upgrade partition with mount point " + mountPoint);
                                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The upgrade partition is preferred among the partitions.");
                                hdDeviceProperties.setPreferred(true);
                            } else {
                                hdDeviceProperties.setPreferred(false);
                            }
                            String deviceName = hdDeviceProperties.getDeviceName();
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): deviceName = " + deviceName);
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): Adding the new device id to the device id hash map.");
                            this.currentDeviceIdsMap.put(deviceName, new MediaDeviceIdentifier(hdDeviceProperties));
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The device [" + deviceName + "] was added to the current map of devices.");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The mount point [" + mountPoint + "] was not found /etc/fstab");
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): The partition with mount point [" + mountPoint + "] was not added to the map of media devices.");
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): mountPoint == null");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateHdDevices(): deviceClassProperties == null");
            }
            Object var17_19 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block24;
            }
            catch (IOException ioexc) {
                Trace.trace(TRACE_MASKF, ioexc);
            }
            break block24;
            {
                catch (Exception exc) {
                    MediaDeviceException mdexc = new MediaDeviceException(exc);
                    Trace.trace(TRACE_MASKF, mdexc);
                    new FrameworkLog(MediaServicesErrorIds._logInfo, 613, mdexc).log();
                    Object var17_20 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block24;
                    }
                    catch (IOException ioexc) {
                        Trace.trace(TRACE_MASKF, ioexc);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException ioexc) {
                    Trace.trace(TRACE_MASKF, ioexc);
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "DiscoverDevices.instantiateHdDevices()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instantiateNonHdDevices() throws MediaDeviceException {
        String deviceName;
        NonHdDeviceProperties nonHdDeviceProperties;
        DeviceClassProperties deviceClassProperties;
        BufferedReader bufferedReader;
        FileReader fileReader;
        String deviceFile;
        String line;
        int rc;
        String[] detectCmd;
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.instantiateNonHdDevices()");
        try {
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): Detecting the diskette drive(s)...");
            detectCmd = new String[]{this.mediaServicesParameters.getParm(DEVICE_DETECT_SCRIPT), "--floppy", this.mediaServicesParameters.getParm("media.log.dir") + "floppy.devices", this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): detectCmd[0] = " + detectCmd[0]);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): detectCmd[1] = " + detectCmd[1]);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): detectCmd[2] = " + detectCmd[2]);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): detectCmd[3] = " + detectCmd[3]);
            rc = RootProcess.executeProgram(detectCmd);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("failure to detect the diskette drive(s)");
            }
            line = null;
            deviceFile = "";
            fileReader = null;
            bufferedReader = null;
            try {
                fileReader = new FileReader(this.mediaServicesParameters.getParm("media.log.dir") + "floppy.devices");
                bufferedReader = new BufferedReader(fileReader);
                block14: while ((line = bufferedReader.readLine()) != null) {
                    Trace.trace(TRACE_MASKF, line);
                    if (line.indexOf("Created at floppy") == -1) continue;
                    line = bufferedReader.readLine();
                    line = bufferedReader.readLine();
                    if (line.indexOf("Hardware Class: floppy") == -1) continue;
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.indexOf("Device File:") == -1) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(line);
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        deviceFile = stringTokenizer.nextToken();
                        int index = deviceFile.lastIndexOf(47);
                        deviceFile = deviceFile.substring(index + 1);
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): device file = " + deviceFile);
                        if (deviceFile != null && deviceFile.length() > 0) {
                            String deviceType = "DD";
                            Trace.trace(TRACE_MASKD, "DiscoverDevices.instantiateNonHdDevices(): device type = " + deviceType);
                            deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
                            if (deviceClassProperties != null) {
                                deviceClassProperties.incrementNumberOfDevices();
                                nonHdDeviceProperties = new NonHdDeviceProperties(deviceClassProperties);
                                Trace.trace(TRACE_MASKD, "DiscoverDevices.instantiateNonHdDevices(): device file = " + deviceFile);
                                nonHdDeviceProperties.setDeviceFile(deviceFile);
                                this.setDisplayableName(nonHdDeviceProperties);
                                deviceName = nonHdDeviceProperties.getDeviceName();
                                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): deviceName = " + deviceName);
                                this.currentDeviceIdsMap.put(deviceName, new MediaDeviceIdentifier(nonHdDeviceProperties));
                                Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): The device " + deviceName + " was add to the current map of devices.");
                                continue block14;
                            }
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): deviceClassProperties == null");
                            continue block14;
                        }
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): (deviceFile == null) || !(deviceFile.length() > 0)");
                        continue block14;
                    }
                }
                Object var14_18 = null;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception ioexc) {
                    Trace.trace(TRACE_MASKF, ioexc);
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception ioexc) {
                Trace.trace(TRACE_MASKF, ioexc);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        try {
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): Detecting the optical drive(s)...");
            detectCmd = new String[]{this.mediaServicesParameters.getParm(DEVICE_DETECT_SCRIPT), "--cdrom --fast", this.mediaServicesParameters.getParm("media.log.dir") + "cdrom.devices", this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): detectCmd[0] = " + detectCmd[0]);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): detectCmd[1] = " + detectCmd[1]);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): detectCmd[2] = " + detectCmd[2]);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): detectCmd[3] = " + detectCmd[3]);
            rc = RootProcess.executeProgram(detectCmd);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("failure to detect the optical drive(s)");
            }
            line = null;
            deviceFile = "";
            fileReader = null;
            bufferedReader = null;
            try {
                fileReader = new FileReader(this.mediaServicesParameters.getParm("media.log.dir") + "cdrom.devices");
                bufferedReader = new BufferedReader(fileReader);
                block16: while ((line = bufferedReader.readLine()) != null) {
                    Trace.trace(TRACE_MASKF, line);
                    String deviceType = "";
                    if (line.indexOf("CD-ROM") != -1) {
                        if (line.indexOf("DVD-RAM") != -1) {
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): Found a DVD-RAM drive.");
                            deviceType = "DV";
                        } else {
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): Found a CD-ROM drive.");
                            deviceType = "CD";
                        }
                    }
                    while ((line = bufferedReader.readLine()) != null) {
                        Trace.trace(TRACE_MASKF, line);
                        if (line.indexOf("Device File:") == -1) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(line);
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        deviceFile = stringTokenizer.nextToken();
                        int index = deviceFile.lastIndexOf(47);
                        deviceFile = deviceFile.substring(index + 1);
                        deviceFile = "cdrom";
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): device file = " + deviceFile);
                        deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
                        if (deviceClassProperties != null) {
                            deviceClassProperties.incrementNumberOfDevices();
                            nonHdDeviceProperties = new NonHdDeviceProperties(deviceClassProperties);
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): device file = " + deviceFile);
                            nonHdDeviceProperties.setDeviceFile(deviceFile);
                            this.setDisplayableName(nonHdDeviceProperties);
                            deviceName = nonHdDeviceProperties.getDeviceName();
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): deviceName = " + deviceName);
                            this.currentDeviceIdsMap.put(deviceName, new MediaDeviceIdentifier(nonHdDeviceProperties));
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): The device " + deviceName + " was added to the current map of devices.");
                            continue block16;
                        }
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): deviceClassProperties == null");
                        continue block16;
                    }
                }
                Object var17_23 = null;
            }
            catch (Throwable throwable) {
                Object var17_24 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException ioexc) {
                    Trace.trace(TRACE_MASKF, ioexc);
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException ioexc) {
                Trace.trace(TRACE_MASKF, ioexc);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): Setting dynamic device properties...");
        Set set = this.deviceClassPropertiesMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String deviceType = (String)iterator.next();
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): deviceType = " + deviceType);
            DeviceClassProperties deviceClassProperties2 = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
            if (deviceClassProperties2.getNumberOfDevices() > 0) {
                this.setDisplayableDescription(deviceClassProperties2);
                this.setPreferred(deviceClassProperties2);
                continue;
            }
            Trace.trace(TRACE_MASKF, "DiscoverDevices.instantiateNonHdDevices(): !(deviceClassProperties.getNumberOfDevices() > 0)");
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.instantiateNonHdDevices()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getHashMapOfUSBDevices() {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.getHashMapOfUSBDevices()");
        HashMap<String, MediaDeviceIdentifier> usbDeviceIdsMap = new HashMap<String, MediaDeviceIdentifier>();
        try {
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): Detecting the USB device(s)...");
            String[] detectCmd = new String[]{this.mediaServicesParameters.getParm(DEVICE_DETECT_SCRIPT), "--usb", this.mediaServicesParameters.getParm("media.log.dir") + "usb.devices", this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): detectCmd[0] = " + detectCmd[0]);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): detectCmd[1] = " + detectCmd[1]);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): detectCmd[2] = " + detectCmd[2]);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): detectCmd[3] = " + detectCmd[3]);
            int rc = RootProcess.executeProgram(detectCmd);
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): rc = " + rc);
            if (rc != 0) {
                throw new IOException("failure to detect the USB device(s).");
            }
            String line = null;
            String deviceFile = "";
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                fileReader = new FileReader(this.mediaServicesParameters.getParm("media.log.dir") + "usb.devices");
                bufferedReader = new BufferedReader(fileReader);
                while ((line = bufferedReader.readLine()) != null) {
                    IOException ioexc3;
                    Object var19_24;
                    String deviceName;
                    DeviceClassProperties deviceClassProperties;
                    String deviceType;
                    StringTokenizer st;
                    String fstab_line;
                    String uniqueId;
                    block34: {
                        IOException ioexc22;
                        Object var16_22;
                        Trace.trace(TRACE_MASKF, line);
                        if (line.indexOf("Unique ID:") == -1) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(line);
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        uniqueId = stringTokenizer.nextToken();
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): uniqueId = " + uniqueId);
                        line = bufferedReader.readLine();
                        if (line.indexOf("Hardware Class: disk") == -1) break block34;
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): The Hardware Class line indicates a USB disk drive.");
                        FileReader fileReader2 = null;
                        BufferedReader bufferedReader2 = null;
                        try {
                            fileReader2 = new FileReader("/etc/fstab");
                            bufferedReader2 = new BufferedReader(fileReader2);
                            fstab_line = null;
                            while ((fstab_line = bufferedReader2.readLine()) != null) {
                                Trace.trace(TRACE_MASKF, fstab_line);
                                if (fstab_line.indexOf(uniqueId) == -1) continue;
                                Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): The fstab line includes the unique id.");
                                st = new StringTokenizer(fstab_line);
                                if (!st.hasMoreTokens()) continue;
                                deviceFile = st.nextToken();
                                int index = deviceFile.lastIndexOf(47);
                                deviceFile = deviceFile.substring(index + 1);
                                Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): deviceFile = " + deviceFile);
                            }
                            var16_22 = null;
                        }
                        catch (Throwable throwable) {
                            var16_22 = null;
                            try {
                                if (bufferedReader2 != null) {
                                    bufferedReader2.close();
                                }
                            }
                            catch (IOException ioexc22) {
                                Trace.trace(TRACE_MASKF, ioexc22);
                            }
                            throw throwable;
                        }
                        try {
                            if (bufferedReader2 != null) {
                                bufferedReader2.close();
                            }
                        }
                        catch (IOException ioexc22) {
                            Trace.trace(TRACE_MASKF, ioexc22);
                        }
                        if (deviceFile != null && deviceFile.length() > 0) {
                            Trace.trace(TRACE_MASKD, "DiscoverDevices.getHashMapOfUSBDevices(): device file = " + deviceFile);
                            deviceType = "UM";
                            Trace.trace(TRACE_MASKD, "DiscoverDevices.getHashMapOfUSBDevices(): device type = " + deviceType);
                            deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
                            if (deviceClassProperties != null) {
                                NonHdDeviceProperties nonHdDeviceProperties = new NonHdDeviceProperties(deviceClassProperties);
                                this.setDisplayableName(nonHdDeviceProperties);
                                nonHdDeviceProperties.setDeviceFile(deviceFile);
                                deviceName = nonHdDeviceProperties.getDeviceName();
                                Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): deviceName = " + deviceName);
                                usbDeviceIdsMap.put(deviceName, new MediaDeviceIdentifier(nonHdDeviceProperties));
                                Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): The device " + deviceName + " was added to the map of USB devices.");
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): deviceClassProperties == null");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): (deviceFile == null) || !(deviceFile.length() > 0)");
                        continue;
                    }
                    if (line.indexOf("Hardware Class: floppy") == -1) continue;
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): The Hardware Class line indicates a USB diskette drive.");
                    FileReader fileReader3 = null;
                    BufferedReader bufferedReader3 = null;
                    try {
                        fileReader3 = new FileReader("/etc/fstab");
                        bufferedReader3 = new BufferedReader(fileReader3);
                        fstab_line = null;
                        while ((fstab_line = bufferedReader3.readLine()) != null) {
                            Trace.trace(TRACE_MASKF, fstab_line);
                            if (fstab_line.indexOf(uniqueId) == -1) continue;
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): The fstab line includes the unique id.");
                            st = new StringTokenizer(fstab_line);
                            if (!st.hasMoreTokens()) continue;
                            deviceFile = st.nextToken();
                            int index = deviceFile.lastIndexOf(47);
                            deviceFile = deviceFile.substring(index + 1);
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): deviceFile = " + deviceFile);
                        }
                        var19_24 = null;
                    }
                    catch (Throwable throwable) {
                        var19_24 = null;
                        try {
                            if (bufferedReader3 != null) {
                                bufferedReader3.close();
                            }
                        }
                        catch (IOException ioexc3) {
                            Trace.trace(TRACE_MASKF, ioexc3);
                        }
                        throw throwable;
                    }
                    try {
                        if (bufferedReader3 != null) {
                            bufferedReader3.close();
                        }
                    }
                    catch (IOException ioexc3) {
                        Trace.trace(TRACE_MASKF, ioexc3);
                    }
                    if (deviceFile != null && deviceFile.length() > 0) {
                        Trace.trace(TRACE_MASKD, "DiscoverDevices.getHashMapOfUSBDevices(): device file = " + deviceFile);
                        deviceType = "DD";
                        Trace.trace(TRACE_MASKD, "DiscoverDevices.getHashMapOfUSBDevices(): device type = " + deviceType);
                        deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
                        if (deviceClassProperties != null) {
                            NonHdDeviceProperties nonHdDeviceProperties = new NonHdDeviceProperties(deviceClassProperties);
                            this.setDisplayableName(nonHdDeviceProperties);
                            nonHdDeviceProperties.setDeviceFile(deviceFile);
                            deviceName = nonHdDeviceProperties.getDeviceName();
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): deviceName = " + deviceName);
                            usbDeviceIdsMap.put(deviceName, new MediaDeviceIdentifier(nonHdDeviceProperties));
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): The device " + deviceName + " was added to the map of USB devices.");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): deviceClassProperties == null");
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.getHashMapOfUSBDevices(): (deviceFile == null) || !(deviceFile.length() > 0)");
                }
                Object var22_27 = null;
            }
            catch (Throwable throwable) {
                Object var22_28 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException ioexc) {
                    Trace.trace(TRACE_MASKF, ioexc);
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException ioexc) {
                Trace.trace(TRACE_MASKF, ioexc);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            MediaDeviceException mediaDeviceException = new MediaDeviceException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.getHashMapOfUSBDevices(): returns " + usbDeviceIdsMap.size() + " devices.");
        return usbDeviceIdsMap;
    }

    HashMap getDevices() {
        Iterator iterator;
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.getDevices()");
        HashMap usbDeviceIdsMap = this.getHashMapOfUSBDevices();
        if (usbDeviceIdsMap != null && !usbDeviceIdsMap.isEmpty()) {
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): Number of USB devices discovered = " + usbDeviceIdsMap.size());
            Trace.trace(TRACE_MASKT, "DiscoverDevices.getDevices(): Adding new USB devices as needed.");
            Set set = usbDeviceIdsMap.keySet();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String deviceName = (String)iterator2.next();
                Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): deviceName = " + deviceName);
                if (this.currentDeviceIdsMap.containsKey(deviceName)) continue;
                Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): The current map of devices does not contain " + deviceName);
                MediaDeviceIdentifier mediaDeviceIdentifier = (MediaDeviceIdentifier)usbDeviceIdsMap.get(deviceName);
                if (mediaDeviceIdentifier != null) {
                    String deviceType = mediaDeviceIdentifier.getDeviceType();
                    if (deviceType != null) {
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): deviceType = " + deviceType);
                        DeviceClassProperties deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
                        if (deviceClassProperties != null) {
                            deviceClassProperties.incrementNumberOfDevices();
                            this.currentDeviceIdsMap.put(deviceName, mediaDeviceIdentifier);
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): The device " + deviceName + " was added to the current map of devices.");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): deviceClassProperties == null");
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): deviceType == null");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): mediaDeviceIdentifier == null");
            }
        } else if (usbDeviceIdsMap == null) {
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): The hash map of detected USB devices is null!");
        } else {
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): The hash map of detected USB devices is empty!");
        }
        HashMap tempMap = new HashMap(this.initialDeviceIdsMap);
        Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): tempMap.size() = " + tempMap.size());
        tempMap.putAll(usbDeviceIdsMap);
        Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): tempMap.size() = " + tempMap.size());
        Set keySet = tempMap.keySet();
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): key = " + key);
        }
        ArrayList<String> removalList = new ArrayList<String>(0);
        if (this.currentDeviceIdsMap != null && !this.currentDeviceIdsMap.isEmpty()) {
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): currentDeviceIdsMap.size() = " + this.currentDeviceIdsMap.size());
            Trace.trace(TRACE_MASKT, "DiscoverDevices.getDevices(): Removing USB devices as needed.");
            Set set = this.currentDeviceIdsMap.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                String deviceName = (String)iterator.next();
                Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): deviceName = " + deviceName);
                if (tempMap.containsKey(deviceName)) continue;
                Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): The device " + deviceName + " is no longer connected.");
                removalList.add(deviceName);
            }
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): currentDeviceIdsMap.size() = " + this.currentDeviceIdsMap.size());
        }
        for (int j = 0; j < removalList.size(); ++j) {
            String deviceName = (String)removalList.get(j);
            if (this.currentDeviceIdsMap.containsKey(deviceName)) {
                Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): currentDeviceIdsMap.contains(" + deviceName + ")");
                MediaDeviceIdentifier mediaDeviceIdentifier = (MediaDeviceIdentifier)this.currentDeviceIdsMap.get(deviceName);
                if (mediaDeviceIdentifier != null) {
                    String deviceType = mediaDeviceIdentifier.getDeviceType();
                    if (deviceType != null) {
                        DeviceClassProperties deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
                        if (deviceClassProperties != null) {
                            deviceClassProperties.decrementNumberOfDevices();
                            this.currentDeviceIdsMap.remove(deviceName);
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): The device " + deviceName + " was removed from the map.");
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): deviceClassProperties == null");
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): deviceType == null");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): mediaDeviceIdentifier == null");
                continue;
            }
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): currentDeviceIdsMap does not contain " + deviceName);
        }
        Set set = this.deviceClassPropertiesMap.keySet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            String deviceType = (String)iterator.next();
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): deviceType = " + deviceType);
            DeviceClassProperties deviceClassProperties = (DeviceClassProperties)this.deviceClassPropertiesMap.get(deviceType);
            if (deviceClassProperties != null) {
                if (deviceClassProperties.getNumberOfDevices() > 0) {
                    this.setDisplayableDescription(deviceClassProperties);
                    this.setPreferred(deviceClassProperties);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): !(deviceClassProperties.getNumberOfDevices() > 0)");
                continue;
            }
            Trace.trace(TRACE_MASKF, "DiscoverDevices.getDevices(): deviceClassProperties == null");
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.getDevices(): returns " + this.currentDeviceIdsMap.size() + " devices.");
        return this.currentDeviceIdsMap;
    }

    private void setDisplayableDescription(DeviceClassProperties deviceClassProperties) {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.setDisplayableDescription(" + deviceClassProperties + ")");
        Set set = this.currentDeviceIdsMap.keySet();
        Iterator iterator = set.iterator();
        if (deviceClassProperties.getNumberOfDevices() == 1) {
            while (iterator.hasNext()) {
                String deviceName = (String)iterator.next();
                Trace.trace(TRACE_MASKF, "DiscoverDevices.setDisplayableDescription(): deviceName = " + deviceName);
                MediaDeviceIdentifier mediaDeviceIdentifier = (MediaDeviceIdentifier)this.currentDeviceIdsMap.get(deviceName);
                if (mediaDeviceIdentifier != null) {
                    MediaDeviceProperties mediaDeviceProperties = mediaDeviceIdentifier.getMediaDeviceProperties();
                    if (mediaDeviceProperties != null) {
                        if (!mediaDeviceProperties.getDeviceType().equals(deviceClassProperties.getDeviceType())) continue;
                        mediaDeviceProperties.setDisplayableDescription(mediaDeviceProperties.getDisplayableName());
                        break;
                    }
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.setDisplayableDescription(): mediaDeviceProperties == null");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "DiscoverDevices.setDisplayableDescription(): mediaDeviceIdentifier == null");
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                String deviceName = (String)iterator.next();
                MediaDeviceIdentifier mediaDeviceIdentifier = (MediaDeviceIdentifier)this.currentDeviceIdsMap.get(deviceName);
                if (mediaDeviceIdentifier != null) {
                    MediaDeviceProperties mediaDeviceProperties = mediaDeviceIdentifier.getMediaDeviceProperties();
                    if (mediaDeviceProperties != null) {
                        if (!mediaDeviceProperties.getDeviceType().equals(deviceClassProperties.getDeviceType())) continue;
                        String count = MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), MediaServicesResourceBundle.NumberOfDevices(++i));
                        String description = mediaDeviceProperties.getDisplayableName().toString() + " " + count;
                        mediaDeviceProperties.setDisplayableDescription(new LocalizableText(description));
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.setDisplayableDescription(): mediaDeviceProperties == null");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "DiscoverDevices.setDisplayableDescription(): mediaDeviceIdentifier == null");
            }
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.setDisplayableDescription()");
    }

    private void setPreferred(DeviceClassProperties deviceClassProperties) {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.setPreferred(" + deviceClassProperties + ")");
        MediaDeviceProperties preferredDevice = null;
        Set set = this.currentDeviceIdsMap.keySet();
        Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): currentDeviceIdsMap.size() = " + this.currentDeviceIdsMap.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String deviceName = (String)iterator.next();
            Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): deviceName = " + deviceName);
            MediaDeviceIdentifier mediaDeviceIdentifier = (MediaDeviceIdentifier)this.currentDeviceIdsMap.get(deviceName);
            if (mediaDeviceIdentifier != null) {
                MediaDeviceProperties mediaDeviceProperties = mediaDeviceIdentifier.getMediaDeviceProperties();
                if (mediaDeviceProperties != null) {
                    String deviceType1 = mediaDeviceProperties.getDeviceType();
                    String deviceType2 = deviceClassProperties.getDeviceType();
                    if (deviceType1 != null && deviceType2 != null) {
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): deviceType1 = " + deviceType1);
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): deviceType2 = " + deviceType2);
                        if (!deviceType1.equals(deviceType2)) continue;
                        if (preferredDevice == null) {
                            preferredDevice = mediaDeviceProperties;
                            continue;
                        }
                        String deviceFile1 = mediaDeviceProperties.getDeviceFile();
                        String deviceFile2 = preferredDevice.getDeviceFile();
                        if (deviceFile1 != null && deviceFile2 != null) {
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): deviceFile1 = " + deviceFile1);
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): deviceFile2 = " + deviceFile2);
                            if (deviceFile1.compareTo(deviceFile2) >= 0) continue;
                            preferredDevice = mediaDeviceProperties;
                            continue;
                        }
                        if (deviceFile1 == null) {
                            Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): mediaDeviceProperties.getDeviceFile() == null");
                            continue;
                        }
                        if (deviceFile2 != null) continue;
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): preferredDevice.getDeviceFile()");
                        continue;
                    }
                    if (deviceType1 == null) {
                        Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): mediaDeviceProperties.getDeviceType() == null");
                        continue;
                    }
                    if (deviceType2 != null) continue;
                    Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): deviceClassProperties.getDeviceType() == null");
                    continue;
                }
                Trace.trace(TRACE_MASKT, "DiscoverDevices.setPreferred(): mediaDeviceProperties == null");
                continue;
            }
            Trace.trace(TRACE_MASKF, "DiscoverDevices.setPreferred(): mediaDeviceIdentifier == null");
        }
        if (preferredDevice != null) {
            preferredDevice.setPreferred(true);
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.setPreferred()");
    }

    private void setDisplayableName(MediaDeviceProperties mediaDeviceProperties) {
        Trace.trace(TRACE_MASKT, "-> DiscoverDevices.setDisplayableName(" + mediaDeviceProperties + ")");
        String deviceType = mediaDeviceProperties.getDeviceType();
        if (deviceType != null) {
            Trace.trace(TRACE_MASKF, "DiscoverDevices.setDisplayableName(): deviceType = " + deviceType);
            if (deviceType.equals("DD")) {
                mediaDeviceProperties.setDisplayableName(new LocalizableText("com/ibm/hwmca/fw/mediasvc/res/mediares", "media.device.diskette"));
            } else if (deviceType.equals("DV")) {
                mediaDeviceProperties.setDisplayableName(new LocalizableText("com/ibm/hwmca/fw/mediasvc/res/mediares", "media.device.dvdram"));
            } else if (deviceType.equals("CD")) {
                mediaDeviceProperties.setDisplayableName(new LocalizableText("com/ibm/hwmca/fw/mediasvc/res/mediares", "media.device.cdrom"));
            } else if (deviceType.equals("UM")) {
                mediaDeviceProperties.setDisplayableName(new LocalizableText("com/ibm/hwmca/fw/mediasvc/res/mediares", "media.device.usbmem"));
            } else {
                Trace.trace(TRACE_MASKF, "DiscoverDevices.setDisplayableName(): An unknown device type " + deviceType + " was encountered.");
            }
        } else {
            Trace.trace(TRACE_MASKF, "DiscoverDevices.setDisplayableName(): deviceType == null");
        }
        Trace.trace(TRACE_MASKT, "<- DiscoverDevices.setDisplayableName()");
    }
}

